function [bestc, bestp, CV] = ottimiz_param_SVM_LOSO_PAR(inst, labels, log2c, log2p, sogg_label, plotflag, scalingtype)
% SVM RBF kernel parameter optimization (C and Gamma) obtained from 
% parameters grid search. The optimization criterion is defined on 
% leave-one-subject-out (LOSO) cross-validation results
% 
% 
% [bestc, bestp] = ottimiz_param_SVM(inst_sc, labels, log2c, log2p, nfold, plotflag)
% 
% inst_sc     = feature set (prescaled/normalized/standardized)
% labels      = classification labels
% log2c       = C parameter values expressed as log2(C)
% log2p       = gamma parameter values expressed as log2(gamma)
% sogg_label  = subject-label for each instance (needed for LOSO cross validation)
% plotflag    = graphical output is displayed if this flag is set to true
% scalingtype = set to 1 for normalization, set to 2 for standardization
% 
% example
% [bestc, bestp] = ottimiz_param_SVM(inst_sc,labels,[0:4:16],[10:-5:-5],sogg_label,1,1)
% 
% [Andrea Mannini: a.mannini@sssup.it; Last modified: Nov 23 2010]




% log2c = [0:4:16];
% log2p = [10:-5:-5];

Lc = length(log2c);
Lp = length(log2p); 
CV = zeros(Lc,Lp);
l2C = zeros(Lc,Lp);
l2P = zeros(Lc,Lp);

soggetti= unique(sogg_label);
S = length(soggetti);
tic;
h2 = waitbar( 0,'Grid search: ottimizzazione parametri');


%% Parallel optimization
for c = 1:Lc
    for g = 1:Lp
        
        input.inst = inst;
        input.labels = labels;
        input.subj_label = sogg_label;
        input.scalingtype = scalingtype;
        input.sc_low = -1;
        input.sc_up = 1;
        input.kernel = 2;
        input.C = 2^log2c(c);
        input.gamma = 2^log2p(g);
        input.Pb = 1;
        input.termination = 0.0000001;
        input.maxlabelnum = max(labels);
        
        output = l1o_valid_svm4_PAR(input);
        
        Acc_aggr = output.Acc_aggr;
        
        CV(c,g) =  Acc_aggr;
        l2C(c,g) = log2c(c);
        l2P(c,g) = log2p(g);
        waitbar( ((c-1)*Lp + g)/(Lc*Lp) ,h2);
    end
%     waitbar((c)/(Lc),h);
end
close(h2);
toc;

[bestcv,ind_best] = max(CV(:));
[ind_bestlc, ind_bestlp] = ind2sub(size(CV),ind_best);

bestlc1 = log2c(ind_bestlc)
bestlp1 = log2p(ind_bestlp)
bestc = 2^ bestlc1;
bestp = 2^ bestlp1;



if (plotflag)
%%% Figura
figure1 = figure('Units', 'normalized', 'Position',[0.2 0.1 0.6 0.8]);
axes1 = axes('Parent',figure1,'Position',[0.1 0.2314 0.7446 0.621],...
    'Layer','top');
box('on'); grid('off');

output1.l2C = l2C;
output1.l2P = l2P;
output1.CV = CV;
output1.bestc = bestc;
output1.bestp = bestp;
output1.bestcv = bestcv;
assignin('base','outputopt',output1);

[cc,h] = contour(l2C,l2P,CV,linspace(min(CV(:)),max(CV(:)),50));
% [cc,h] = contourf(l2C,l2P,CV,linspace(min(CV(:)),max(CV(:)),50));
% [cc,h] = contourf(l2C,l2P,CV, [0:.1:105]);
h = clabel(cc,h,linspace(min(CV(:)), max(CV(:)), 50) );
% h = clabel(cc,h, [0:5:105]);
set(h,'BackgroundColor',[1 1 .6])
xlabel('log_2 (C)');
ylabel('log_2 (\gamma)');
title(['Support Vector Classification: optimization of parameters' ], 'FontWeight', 'Bold');
% Create colorbar
colorbar('peer',axes1,'ZGrid','on','YGrid','on','XGrid','on');
% Resize the axes in order to prevent it from shrinking.
set(axes1,'Position',[0.1 0.2314 0.7446 0.621]);
% Create textbox
annotation(figure1,'textbox',[0.01347 0.01514 0.9633 0.1038],...
    'String',{['Best parameters set: log_2(C) = ' num2str(log2(bestc)) ', log_2(\gamma)= ' num2str(log2(bestp))];...
    ['C = ' num2str(bestc) ', \gamma= ' num2str(bestp) ', \bfMSE = ' num2str(bestcv) '']},...
    'FitBoxToText','off',...
    'BackgroundColor',[1 1 1]);
end
